function [Return] = Gesamtsteifigkeitsmatrix_Bilden(iANZAHL_KNOTEN,aSTABVERBINDUNGEN,aALPHA,aL,aEA,aLAGERBEDINGUNGEN)
    %Initialisierung des Containers (Cell-Arrays)-----------------
    aVERBINDUNGSCONTAINER=cell(iANZAHL_KNOTEN);
    for(i=1:1:iANZAHL_KNOTEN)
        for(j=1:1:iANZAHL_KNOTEN)
            aVERBINDUNGSCONTAINER(i,j)={[0,0;0,0]};
        end
    end
    
    %Verbindungen der Knoten herstellen
    for(i=1:1:size(aSTABVERBINDUNGEN,1))
        j=aSTABVERBINDUNGEN(i,2);%Anfangsknoten
        k=aSTABVERBINDUNGEN(i,3);%Endknoten
        Speicher=Elementsteifigkeitsmatrix_Bilden(aEA,aL,aALPHA,i);
        aVERBINDUNGSCONTAINER(j,j)= {[ ...
                                        aVERBINDUNGSCONTAINER{j,j}(1,1)+Speicher(1,1), ...
                                        aVERBINDUNGSCONTAINER{j,j}(1,2)+Speicher(1,2); ...
                                        aVERBINDUNGSCONTAINER{j,j}(2,1)+Speicher(2,1), ...
                                        aVERBINDUNGSCONTAINER{j,j}(2,2)+Speicher(2,2) ...
                                    ]};
        aVERBINDUNGSCONTAINER(j,k)= {[ ...
                                        aVERBINDUNGSCONTAINER{j,k}(1,1)-Speicher(1,1), ...
                                        aVERBINDUNGSCONTAINER{j,k}(1,2)-Speicher(1,2); ...
                                        aVERBINDUNGSCONTAINER{j,k}(2,1)-Speicher(2,1), ...
                                        aVERBINDUNGSCONTAINER{j,k}(2,2)-Speicher(2,2) ...
                                    ]};
        aVERBINDUNGSCONTAINER(k,j)= {[ ...
                                        aVERBINDUNGSCONTAINER{k,j}(1,1)-Speicher(1,1), ...
                                        aVERBINDUNGSCONTAINER{k,j}(1,2)-Speicher(1,2); ...
                                        aVERBINDUNGSCONTAINER{k,j}(2,1)-Speicher(2,1), ...
                                        aVERBINDUNGSCONTAINER{k,j}(2,2)-Speicher(2,2) ...
                                    ]};
        aVERBINDUNGSCONTAINER(k,k)= {[ ...
                                        aVERBINDUNGSCONTAINER{k,k}(1,1)+Speicher(1,1), ...
                                        aVERBINDUNGSCONTAINER{k,k}(1,2)+Speicher(1,2); ...
                                        aVERBINDUNGSCONTAINER{k,k}(2,1)+Speicher(2,1), ...
                                        aVERBINDUNGSCONTAINER{k,k}(2,2)+Speicher(2,2) ...
                                    ]};
	end
    
    %Einbauen der Randbedingungen
    for(i=1:1:size(aLAGERBEDINGUNGEN,1))
        iKNOTEN=aLAGERBEDINGUNGEN(i,1);
        iTRANSLATIONSSPERRE=aLAGERBEDINGUNGEN(i,2);% 1 ist x, 2 ist y, gleiches gilt fr die Cell-Array-Logik
        for(j=1:1:iANZAHL_KNOTEN)%Streichen in den Spalten des Containers
            aVERBINDUNGSCONTAINER{j,iKNOTEN}(1,iTRANSLATIONSSPERRE)=0;
            aVERBINDUNGSCONTAINER{j,iKNOTEN}(2,iTRANSLATIONSSPERRE)=0;
        end
        for(k=1:1:iANZAHL_KNOTEN)%Streichen in den Zeilen des Containers
            aVERBINDUNGSCONTAINER{iKNOTEN,k}(iTRANSLATIONSSPERRE,1)=0;
            aVERBINDUNGSCONTAINER{iKNOTEN,k}(iTRANSLATIONSSPERRE,2)=0;
        end
        aVERBINDUNGSCONTAINER{iKNOTEN,iKNOTEN}(iTRANSLATIONSSPERRE,iTRANSLATIONSSPERRE)=1;
    end
    
    %Explosion des Cell-Arrays in ein Array
    for(i=2:2:2*iANZAHL_KNOTEN)
        for(j=2:2:2*iANZAHL_KNOTEN)
            for(k=1:1:2)
                for(l=1:1:2)
                    Return(i+k-2,j+l-2)=aVERBINDUNGSCONTAINER{i/2,j/2}(k,l);
                end
            end
        end
    end
end
